PROGRAM BlauMann;
USES Crt,Graph;

CONST DiskDatei = 'BlHi.dat';

TYPE
  Datensatztyp =  RECORD
                    Punkte : INTEGER;
                    Name : STRING[10];
                  END;

VAR
   LogDatei : FILE OF DatensatzTyp;
   a :CHAR;
   Genommen,X,Y,Position : INTEGER;
   Versteck : ARRAY [1..375] OF INTEGER;
   BeEnde : BOOLEAN;

PROCEDURE GrEin;
VAR
  Driver,Mode : INTEGER;

BEGIN
  Driver := InstallUserDriver('Egavga', nil);
  if Driver = grError then
    Halt(1);
  Mode := 1;
  InitGraph(Driver, Mode, '');
  SetFillStyle(SolidFill,2);
  Bar(0,0,GetMaxX,GetMaxY);
END;


PROCEDURE Feld;
VAR X,Y,i :INTEGER;
BEGIN
FOR i := 1 TO 16 DO Line(20,20*i,520,20*i);
FOR i := 1 TO 26 DO Line(20*i,20,20*i,320);
END;

PROCEDURE Zahlen;

VAR I,k: INTEGER;

BEGIN
Randomize;

FOR I := 1 TO 375 DO VerSteck[I] := Random(9)+1;
END;

PROCEDURE Zaus;
VAR zahler,a,i,Xl,Yl: INTEGER;
    ztext : String [2];

BEGIN
Yl:=5;
Zahler:=0;
FOR a:= 1 TO 15 DO
BEGIN
 Yl:=Yl+20;
 Xl:=5;
 FOR i:= 1 TO 25 DO
 BEGIN
   Zahler :=Zahler+1;
   Xl:=xl+20;
   STR(Versteck[Zahler],ztext);
   OUTTEXTXY(xl,yl,ztext);
 END;
END;
END;

PROCEDURE Rechts;

VAR Zahl,i : INTEGER;
    Ende : BOOLEAN;

BEGIN
IF X < 500
THEN BEGIN
  Zahl := Versteck[Position+1];
  Ende := False;
  I:=0;
  REPEAT
     i :=i+ 1;
     Position := Position +1;
     IF (GetPixel(X+21,Y+1) <> 1) AND (X <500)
     THEN BEGIN
       SetfillStyle(1,Blue);
       BAR(x+20,y,x+40,y+20);
       Setcolor(15);
       Rectangle(x,y,x+20,y+20);
       Setcolor(red);
       X:=x+20;
       Rectangle(x,y,x+20,y+20);
       Genommen := Genommen +1;
     END
     ELSE Ende := TRUE;
  UNTIL (I=Zahl) OR (Ende = TRUE)
END;
Setcolor(Red);

IF (Ende = TRUE)
THEN BEGIN
      OutTextXY(560,125,'Ende');
      beEnde := TRUE;
     END;

END;

PROCEDURE Links;
VAR Zahl,i : INTEGER;
    Ende : BOOLEAN;

BEGIN
IF x > 20
THEN BEGIN
  Zahl := Versteck[Position-1];
  Ende := False;
  I:=0;
  REPEAT
     i :=i+ 1;
     Position := Position -1;
     IF (GetPixel(X-19,Y+1) <> 1) AND (x >20)
     THEN BEGIN
       SetfillStyle(1,Blue);
       BAR(x-20,y,x,y+20);
       Setcolor(15);
       Rectangle(x,y,x+20,y+20);
       Setcolor(red);
       x:=x-20;
       Rectangle(x,y,x+20,y+20);
       Genommen := Genommen +1;
     END
     ELSE Ende := TRUE;
  UNTIL (I=Zahl) OR (Ende = TRUE)
END;
Setcolor(Red);

IF (Ende = TRUE)
THEN BEGIN
      OutTextXY(560,125,'Ende');
      beEnde := TRUE;
     END;

END;

PROCEDURE Oben;
VAR Zahl,i : INTEGER;
    Ende : BOOLEAN;

BEGIN
IF y > 20
THEN BEGIN
  Zahl := Versteck[Position-25];
  Ende := False;
  I:=0;
  REPEAT
     i :=i+ 1;
     Position := Position -25;
     IF (GetPixel(X+1,Y-19) <> 1) AND (y >20)
     THEN BEGIN
       SetfillStyle(1,Blue);
       BAR(x,y-20,x+20,y);
       Setcolor(15);
       Rectangle(x,y,x+20,y+20);
       Setcolor(red);
       y:=y-20;
       Rectangle(x,y,x+20,y+20);
       Genommen := Genommen +1;
     END
     ELSE Ende := TRUE;
  UNTIL (I=Zahl) OR (Ende = TRUE)
END;
Setcolor(Red);

IF (Ende = TRUE)
THEN BEGIN
       OutTextXY(560,125,'Ende');
       BeEnde := TRUE;
     END;

END;

PROCEDURE Unten;

VAR Zahl,i : INTEGER;
    Ende : BOOLEAN;

BEGIN
IF y < 300
THEN BEGIN
  Zahl := Versteck[Position+25];
  Ende := False;
  I:=0;
  REPEAT
     i :=i+ 1;
     Position := Position + 25;
     IF (GetPixel(X+1,Y+21) <> 1) AND (y <300)
     THEN BEGIN
       SetfillStyle(1,Blue);
       BAR(x,y+20,x+20,y+40);
       Setcolor(15);
       Rectangle(x,y,x+20,y+20);
       Setcolor(red);
       y:=y+20;
       Rectangle(x,y,x+20,y+20);
       Genommen := Genommen +1;
     END
     ELSE Ende := TRUE;
  UNTIL (I=Zahl) OR (Ende = TRUE)
END;
Setcolor(Red);

IF (Ende = TRUE)
THEN BEGIN
      OutTextXY(560,125,'Ende');
      BeEnde := TRUE;
     END;

END;


PROCEDURE Main;
VAR tgen: STRING [3];

BEGIN
 IF Keypressed
 THEN BEGIN
        A:= Readkey;
        IF A = #0
        THEN BEGIN
              A:=Readkey;
              CASE A OF
                #77 : Rechts;
                #75 : Links;
                #72 : Oben;
                #80 : Unten;
              END;
             END;
       STR(Genommen,tgen);
       Setcolor(Green);
       OuttextXY(550,100,'');
       Setcolor(0);
       OuttextXY(550,100,tgen);
       OuttextXY(570,100,' /375');
      END;
END;

PROCEDURE Smilyg;
BEGIN
  Setcolor(Yellow);
  Circle(600,50,15);
  SetFillStyle(1,14);
  Floodfill(600,50,14);
  Setcolor(0);
  Circle(595,44,3);
  Circle(605,44,3);
  SetFillStyle(1,0);
  Floodfill(605,44,0);
  Floodfill(595,44,0);
  Arc(600, 55, 180, 360, 9);
END;

PROCEDURE Smilyb;
BEGIN
   Setcolor(14);
   Arc(600, 55, 180, 360, 9);
   Setcolor(0);
   Arc(600, 58, 360, 180, 8);
END;

PROCEDURE Intro;
BEGIN
ClrScr;
Writeln('                      Blaumann Ver 1.2 (c) 1997-98');
Writeln;
Writeln('       Als du am Morgen aufstehst, bemerkst du, ');
Writeln('       da dein Pool voller grner Springalgen ist.');
Writeln('       Deine Aufgabe ist es jetzt, diese Algen zu vernichten.');
Writeln('       Achte aber darauf, da dein Reinigungsgert nur auf die');
WriteLn('       Algen kommt und nicht auf sauberes Wasser ober den Rand');
Writeln('       des Beckens.');
Writeln;
Writeln;
Writeln('                          Deine Tasten sind : ');
Writeln('                              <   =  Links ');
Writeln('                              >   =  Rechts');
Writeln('                                 =  Oben');
Writeln('                                 =  Unter');
Writeln('                             Esc  =  Ende');
Writeln;
Writeln('                              >> Taste << ');
REPEAT UNTIL Keypressed;
Readkey;
END;

PROCEDURE Erstellen;
BEGIN
  Assign(logdatei,Diskdatei);
  Rewrite(Logdatei);
  Close(Logdatei);
END;

PROCEDURE Hiscore;
VAR
    I : INTEGER;
    Merker,Datensatz : Datensatztyp;

BEGIN
  {$I-}
  Assign(logdatei,Diskdatei);
  Reset(Logdatei);
  Close(Logdatei);
  {$I+}

  IF IOResult <> 0 THEN Erstellen;

  Assign(logdatei,Diskdatei);
  Reset(Logdatei);

  IF FileSize(Logdatei) >= 41
  THEN BEGIN
         Seek(Logdatei,40);
         Truncate(Logdatei);
       END;

  ClrScr;
  IF FileSize(Logdatei) > 0
  THEN BEGIN
        Seek (Logdatei,FileSize(Logdatei)-1);
        Read(Logdatei,Merker);
       END
  ELSE Merker.punkte := 0;

  Datensatz.Punkte := Genommen;

  IF (Datensatz.Punkte > Merker.punkte) OR (FileSize(Logdatei) = 0)
  OR ((FileSize(Logdatei) < 40))
  THEN BEGIN
         Writeln('Bitte geben sie ihren Namen ein');
         Readln(Datensatz.name);

         IF FileSize(Logdatei) = 0
         THEN  Write(Logdatei,Datensatz)
         ELSE BEGIN
               I:=1;
               REPEAT
                 Seek (Logdatei,FileSize(Logdatei)-i);
                 Read(Logdatei,Merker);

                 IF Datensatz.Punkte < Merker.Punkte
                 THEN BEGIN
                        Write(Logdatei,Datensatz);
                        I:=0;
                      END

                 ELSE BEGIN
                        Write(Logdatei,Merker);

                        IF I = 1
                        THEN BEGIN
                               IF Filesize(Logdatei) - I = 0
                               THEN BEGIN
                                 Seek (Logdatei,0);
                                 Write(Logdatei,Datensatz);
                               END;
                               I:=3
                             END
                        ELSE BEGIN
                               IF Filesize(Logdatei) - I = 0
                               THEN BEGIN
                                 Seek (Logdatei,0);
                                 Write(Logdatei,Datensatz);
                               END;
                               I:=I + 1;
                            END;

                      END;
               UNTIL (Filesize(Logdatei)-I < 0) OR (I=0);
              END;
       END;
  IF FileSize(Logdatei) >= 41
  THEN BEGIN
         Seek(Logdatei,40);
         Truncate(Logdatei);
       END;
  Close(Logdatei);
END;

PROCEDURE HiAusgeben;
VAR
   I : INTEGER;
   Datensatz : Datensatztyp;

BEGIN
  ClrScr;
  GotoXY(30,1);
  Writeln('>> H  I  S  C  O  R  E <<');
  Assign(Logdatei,Diskdatei);
  Reset(Logdatei);

  FOR I := 1 TO FileSize(Logdatei) DO
  BEGIN
    IF I = 1
    THEN TextColor(Red)
    ELSE TextColor(Blue);
    Read(Logdatei,Datensatz);
    WITH Datensatz DO
    BEGIN
      IF I < 20
      THEN  Writeln('Platz ',I,' : ',Punkte,' - ',Name)
      ELSE BEGIN
             GotoXY(40,i-18);
             Write('Platz ',I,' : ',Punkte,' - ',Name)
           END;
    END;
  END;
  Close(Logdatei);
  GotoXY(1,22);
  WriteLn('Ihre Punkte : ',Genommen);
END;

PROCEDURE Spiel;
BEGIN
  Grein;
  X:=20;
  Y:=20;
  Position := 1;
  Genommen := 0;
  Feld;
  Zahlen;
  ZAus;
  SetfillStyle(1,Blue);
  BAR(x,y,x+20,y+20);
  Setcolor(red);
  Rectangle(x,y,x+20,y+20);
  Genommen := Genommen +1;
  BeEnde := False;
  Setcolor(0);
  OuttextXY(550,100,'1');
  OuttextXY(570,100,' /375');
  Smilyg;
  OutTextXY(570,330,'Blaumann');
  OutTextXY(570,340,'Ver. 1.2');

  REPEAT
   Main;
  UNTIL (A=#27) OR (BeEnde = TRUE) OR (Genommen = 375);

  A:=#0;
  IF BeEnde = True
  THEN Smilyb;

  OutTextXY(200,330,'Bitte Enter drcken');
  REPEAT
  UNTIL Readkey = #13;
  CloseGraph;
  Hiscore;
  Hiausgeben;
END;

BEGIN
TextColor(Blue);
Intro;
REPEAT
 Spiel;
 Write('Neues Spiel? (j/n)');
UNTIL Readkey IN ['n','N',#27];
TextColor(White);
ClrScr;
END.